unit Geometria;
interface
uses Windows, Classes, Graphics, GRafGeomListU;

type
// A TPozicio absztrakt alaposztaly
 TPozicio=Class
   protected
     x,y : integer;
   public
     constructor Create(a,b:integer);
     procedure Mozgat(hovax, hovay:integer);
     procedure Rajzol(szin:TColor); virtual;abstract;
     function Szine:TColor;dynamic; abstract;
     function Terulet:real; virtual;abstract;
     procedure Frissit;
     function GetX:integer;
     function GetY:integer;
 end;

// A TPont osztaly
 TPont=Class(TPozicio)
   protected
     c : TColor;
   public
     constructor Create(px,py:integer;szin:TColor);
     function Szine:TColor;override;
     procedure Szinez(szin:TColor);
     procedure Rajzol(szin:TColor); override;
     function Terulet:real; override;
 end;

// A TKor osztaly
 TKor=Class(TPont)
   protected
     r : integer;
   public
     constructor Create(kpx,kpy:integer;
                        szin:TColor; sugar:integer);
     procedure Rajzol(szin:TColor);override;
     function Terulet:real; override;
 end;

// A TNegyzet osztaly
 TNegyzet=Class(TPont)
   protected
     a : integer;
   public
     constructor Create(kpx,kpy:integer;
                        szin:TColor; oldal:integer);
     procedure Rajzol(szin:TColor);override;
     function Terulet:real; override;
 end;

// A TTeglalap osztaly
 TTeglalap=Class(TNegyzet)
   protected
     b : integer;
   public
     constructor Create(kpx,kpy:integer;
                        szin:TColor; a,b:integer);
     procedure Rajzol(szin:TColor);override;
     function Terulet:real; override;
 end;

implementation

// A TPozicio osztaly metdusai
 constructor TPozicio.Create(a,b:integer);
 begin
   inherited create;
   x:=a; y:=b;
 end;

 procedure TPozicio.Mozgat(hovax, hovay:integer);
 begin
    Rajzol(form1.color);
    x:=hovax;
    y:=hovay;
    Rajzol(Szine);
 end;

 procedure TPozicio.Frissit;
 begin
   Rajzol(Szine);
 end;

 function TPozicio.GetX:integer;
 begin
   result:=x;
 end;

 function TPozicio.GetY:integer;
 begin
   result:=y;
 end;

// A TPont osztaly metdusai
 constructor TPont.Create(px,py:integer; szin:TColor);
 begin
   inherited Create(px,py);
   Szinez(szin);
 end;

 function TPont.Szine:TColor;
 begin
   result:=c;
 end;

 procedure TPont.Szinez(szin:TColor);
 begin
   c:=szin;
   Rajzol(szin);
 end;

 procedure TPont.Rajzol(szin:TColor);
 begin
   form1.canvas.Pen.Color:=szin;
   form1.canvas.Brush.Style:=bsClear;
   form1.canvas.Moveto(x-5,y);
   form1.canvas.Lineto(x+5,y);
   form1.canvas.Moveto(x,y-5);
   form1.canvas.Lineto(x,y+5);
 end;

 function TPont.Terulet:real;
 begin
   result:=0;
 end;

// A TKor osztaly metdusai
 constructor TKor.Create(kpx,kpy:integer;
                         szin:TColor; sugar:integer);
 begin
   r:=sugar;
   inherited Create(kpx,kpy,szin);
 end;

 procedure TKor.Rajzol(szin:TColor);
 begin
   form1.canvas.Pen.Color:=szin;
   form1.canvas.Brush.Style:=bsClear;
   form1.canvas.Ellipse(Rect(x-r,y-r,x+r,y+r));
 end;

 function TKor.Terulet:real;
 begin
   result:=sqr(r)*pi;
 end;

 // A TNegyzet osztaly metdusai
 constructor TNegyzet.Create(kpx,kpy:integer;
                        szin:TColor; oldal:integer);
 begin
   a:=oldal;
   inherited Create(kpx,kpy,szin);
 end;

 procedure TNegyzet.Rajzol(szin:TColor);
 begin
   form1.canvas.Pen.Color:=szin;
   form1.canvas.Brush.Style:=bsClear;
   form1.canvas.Rectangle(Rect(x-a div 2,y-a div 2,
                               x+a div 2,y+a div 2));
 end;

 function TNegyzet.Terulet:real;
 begin
   result:=sqr(a);
 end;


// A TTeglalap osztaly metdusai
 constructor TTeglalap.Create(kpx,kpy:integer;
                        szin:TColor; a,b:integer);
 begin
   self.b:=b;
   inherited Create(kpx,kpy,szin,a);
 end;

 procedure TTeglalap.Rajzol(szin:TColor);
 begin
   form1.canvas.Pen.Color:=szin;
   form1.canvas.Brush.Style:=bsClear;
   form1.canvas.Rectangle(Rect(x-a div 2,y-b div 2,
                               x+a div 2,y+b div 2));
 end;

 function TTeglalap.Terulet:real;
 begin
   result:=a*b;
 end;

end.




